/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.contentassist;

import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class AbstractInformationControlManager
extends org.eclipse.jface.text.AbstractInformationControlManager {
    private int fVerticalOffset;
    private String fInformation;
    private boolean fEnforceAsMinimalSize = false;
    private boolean fEnforceAsMaximalSize = false;
    private AbstractInformationControlManager.Anchor fAnchor;
    private AbstractInformationControlManager.Anchor fComputedAnchor = this.fAnchor = ANCHOR_BOTTOM;

    protected AbstractInformationControlManager(IInformationControlCreator creator) {
        super(creator);
    }

    public void setSizeConstraints(int widthInChar, int heightInChar, boolean enforceAsMinimalSize, boolean enforceAsMaximalSize) {
        super.setSizeConstraints(widthInChar, heightInChar, enforceAsMinimalSize, enforceAsMaximalSize);
        this.fEnforceAsMinimalSize = enforceAsMinimalSize;
        this.fEnforceAsMaximalSize = enforceAsMaximalSize;
    }

    public void setAnchor(AbstractInformationControlManager.Anchor anchor) {
        super.setAnchor(anchor);
        this.fAnchor = anchor;
    }

    protected final void setInformation(String information, Rectangle subjectArea, int verticalOffset) {
        this.fVerticalOffset = verticalOffset;
        this.fInformation = information;
        this.setInformation(information, subjectArea);
    }

    protected boolean updateLocation(Point location, Point size, Rectangle displayArea, AbstractInformationControlManager.Anchor anchor) {
        int displayLowerRightX = displayArea.x + displayArea.width;
        int displayLowerRightY = displayArea.y + displayArea.height;
        int lowerRightX = location.x + size.x;
        int lowerRightY = location.y + size.y;
        if (ANCHOR_BOTTOM == anchor || ANCHOR_TOP == anchor) {
            if (lowerRightX > displayLowerRightX) {
                location.x -= lowerRightX - displayLowerRightX;
            }
            return location.x >= 0 && location.y >= 0;
        }
        if (ANCHOR_RIGHT == anchor || ANCHOR_LEFT == anchor) {
            if (ANCHOR_RIGHT == anchor) {
                if (location.x - size.x * 3 < 0) {
                    return true;
                }
                if (lowerRightX > displayLowerRightX) {
                    return false;
                }
            } else if (location.x < displayArea.x) {
                return false;
            }
            if (lowerRightY > displayLowerRightY) {
                location.y -= lowerRightY - displayLowerRightY;
            }
            return location.x >= 0 && location.y >= 0;
        }
        if (ANCHOR_GLOBAL == anchor) {
            if (lowerRightX > displayLowerRightX) {
                location.x -= lowerRightX - displayLowerRightX;
            }
            if (lowerRightY > displayLowerRightY) {
                location.y -= lowerRightY - displayLowerRightY;
            }
            return location.x >= 0 && location.y >= 0;
        }
        return false;
    }

    protected void doShowInformation() {
        super.doShowInformation();
        this.fInformation = null;
    }

    protected void hideInformationControl() {
        super.hideInformationControl();
        this.fInformation = null;
    }

    protected Point computeInformationControlLocation(Rectangle subjectArea, Point controlSize) {
        Point upperLeft;
        Rectangle displayBounds = this.getSubjectControl().getDisplay().getClientArea();
        this.fComputedAnchor = this.fAnchor;
        while (!this.updateLocation(upperLeft = this.computeLocation(subjectArea, controlSize, this.fComputedAnchor), controlSize, displayBounds, this.fComputedAnchor)) {
            this.fComputedAnchor = this.getNextFallbackAnchor(this.fComputedAnchor);
            if (this.fComputedAnchor != this.fAnchor && this.fComputedAnchor != null) continue;
        }
        return upperLeft;
    }

    private void internalShowInformationControl(Rectangle subjectArea, String information) {
        IInformationControl informationControl = this.getInformationControl();
        if (informationControl != null) {
            IInformationControlExtension extension;
            Point sizeConstraints = this.computeSizeConstraints(this.getSubjectControl(), this.getSubjectArea(), informationControl);
            informationControl.setSizeConstraints(sizeConstraints.x, sizeConstraints.y);
            if (informationControl instanceof IInformationControlExtension2) {
                ((IInformationControlExtension2)informationControl).setInput((Object)information);
            } else {
                informationControl.setInformation(information.toString());
            }
            if (informationControl instanceof IInformationControlExtension && !(extension = (IInformationControlExtension)informationControl).hasContents()) {
                return;
            }
            Point size = null;
            Point location = null;
            Rectangle bounds = this.restoreInformationControlBounds();
            if (bounds != null) {
                if (bounds.x > -1 && bounds.y > -1) {
                    location = new Point(bounds.x, bounds.y);
                }
                if (bounds.width > -1 && bounds.height > -1) {
                    size = new Point(bounds.width, bounds.height);
                }
            }
            if (size == null) {
                size = informationControl.computeSizeHint();
            }
            if (this.fEnforceAsMinimalSize) {
                if (size.x < sizeConstraints.x) {
                    size.x = sizeConstraints.x;
                }
                if (size.y < sizeConstraints.y) {
                    size.y = sizeConstraints.y;
                }
            }
            if (this.fEnforceAsMaximalSize) {
                if (size.x > sizeConstraints.x) {
                    size.x = sizeConstraints.x;
                }
                if (size.y > sizeConstraints.y) {
                    size.y = sizeConstraints.y;
                }
            }
            informationControl.setSize(size.x + 5, size.y);
            if (location == null) {
                location = this.computeInformationControlLocation(subjectArea, size);
            }
            if ((this.fComputedAnchor == ANCHOR_LEFT || this.fComputedAnchor == ANCHOR_RIGHT) && this.fVerticalOffset != 0) {
                location.y = this.fVerticalOffset;
            }
            informationControl.setLocation(location);
            this.showInformationControl(subjectArea);
        }
    }
}

